package com.agilex.healthcare.directscheduling.linkbuilder;

import com.agilex.healthcare.mobilehealthplatform.domain.AtomLink;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.atom.rel;
import com.agilex.healthcare.directscheduling.domain.BookedAppointment;
import com.agilex.healthcare.directscheduling.domain.BookedAppointments;
import com.agilex.healthcare.directscheduling.domain.SchedulingManagerLinkTitles;

import javax.ws.rs.core.UriBuilder;
import java.net.URI;

/**
 * Created with IntelliJ IDEA.
 * User: patelh
 * Date: 10/3/13
 * Time: 9:24 AM
 * To change this template use File | Settings | File Templates.
 */
public class DSCancelAppointmentLinkBuilder {

    private URI baseUri;

    public DSCancelAppointmentLinkBuilder(URI baseUri) {
        this.baseUri = baseUri;
    }

    public void fillLinks(BookedAppointments bookedAppointments, PatientIdentifier patientIdentifier, String siteCode){
        if(bookedAppointments != null && bookedAppointments.size() > 0 ){
            for(BookedAppointment bookedAppointment : bookedAppointments){
                fillCustomRelatedLinks(bookedAppointment, patientIdentifier, siteCode);
            }
        }
    }

    protected void fillCustomRelatedLinks(BookedAppointment bookedAppointment, PatientIdentifier patientIdentifier, String siteCode){
        AtomLink link = new AtomLink();
        link.setRel(rel.related);
        URI cancelAppointmentURI = UriBuilder.fromPath(getPath()).path("direct-scheduling").path("site").path(siteCode).path("patient").path(patientIdentifier.getAssigningAuthority()).path(patientIdentifier.getUniqueId()).path("cancel-appointment").build();
        link.setHref(cancelAppointmentURI);
        link.setTitle(SchedulingManagerLinkTitles.CancelAppointment);
        bookedAppointment.getLink().add(link);
    }

    protected String getPath() {
        return this.baseUri.getPath();
    }
}
